#!/usr/bin/python

import sqlite3
import csv
import xlrd
import os
import sys

#Delete old Database file
try:
    os.remove("CCA.db")
except OSError:pass


conn = sqlite3.connect('CCA.db')

print("\n")
print ("-------------------------CCA Database & Table Generation------------------------- ");
print ("--------------------------------------------------------------------------------- ");
print ("Information: CCA Database created successfully ");


#Creating CCASHIPMENTS TABLE

conn.execute (''' CREATE TABLE CCASHIPMENTS
    (REFERENCE LONG NOT NULL,
	OTHER_REFERENCE TEXT,
	SHIPMENT_DATE TEXT NOT NULL,
	PALLET_COUNT INT NOT NULL,
	CUST CHAR(50) NOT NULL,
	CUST_ADDRESS CHAR(50) NOT NULL,
	DELIVERY_NUM NOT NULL,
	SOLD_TO NUM NOT NULL,
	TPPT NOT NULL,
	FWDING_AGENT NOT NULL,
	PROC_TIME NOT NULL,
	SHIP_TYPE NOT NULL,
	SHIP_COMP NOT NULL,
	SUBSNO INT NOT NULL);''')

print ("Information: CCASHIPMENTS Table created successfully");

	
#Creating CCAVENDORS TABLE
	
conn.execute (''' CREATE TABLE CCAVENDORS
    (SAP_FWDING LONG NOT NULL,
	TPPT NOT NULL,
    CUSTCHEP_ID INT NOT NULL);''')

print ("Information: CCAVENDORS Table created successfully");

#Creating CCAOUTLETS TABLE
	
conn.execute (''' CREATE TABLE CCAOUTLETS
    (OUTLET NOT NULL,
	SAP_FWDING LONG NOT NULL,
	OUTLETCHEP_ID INT NOT NULL);''')

print ("Information: CCAOUTLETS Table created successfully");

#Creating CHEPINFO TABLE


conn.execute (''' CREATE TABLE CHEPINFO
    (LINENO INTEGER PRIMARY KEY AUTOINCREMENT,
    REFERENCE LONG NOT NULL,
    OTHER_REFERENCE TEXT,
	
    SHIPMENT_DATE TEXT NOT NULL,
    PALLET_COUNT INT NOT NULL,
    CUST CHAR(50) NOT NULL,
	CUSTOMER_SAP INT NOT NULL,
	CUSTCHEP_ID CHAR(50) NOT NULL,
	PROC_TIME NOT NULL);''')
	
print ("Information: CHEPINFO Table created successfully");


#Creating CHEPEXPORT TABLE
	
conn.execute (''' CREATE TABLE CHEPEXPORT
    (LINE_TYPE CHAR(1) NOT NULL,
    RECORD_NUM INT(5) NOT NULL,
    DOCKET_NUMBER CHAR(13) NOT NULL,
	SENDER TEXT(10) NOT NULL,
	RECEIVER TEXT(10) NOT NULL,
	DOD TEXT(8) NOT NULL,
	DOR TEXT(8) NOT NULL,
	EFD TEXT(8) NOT NULL,
	REF1 CHAR(16) NULL,
	REF2 CHAR(16) NULL,
	MATERIAL INT(10) NULL,
	QUANTITY INT(6) NULL);''')

print ("Information: CHEPEXPORT Table created successfully");


#Creating TEMP TABLE
	
conn.execute (''' CREATE TABLE TEMP
    (LINE_TYPE CHAR(1) NOT NULL,
	DOCKET_NUMBER CHAR(13) NOT NULL,
	DATE TEXT(8) NOT NULL,
    SENDER INT(5) NOT NULL,
	MATERIAL INT (5) NOT NULL);''')

print ("Information: TEMP Table created successfully");


conn.commit();
conn.close();

